@extends('frontend.layouts.app')
@push('style')
<style>
    .header-style-two {
        background: rgba(40, 60, 71, 0.40);
    }

    .mt-lg-5 {
        margin-top: 7rem !important;
    }
</style>
@endpush
@section('content')

<section class="checkout-page mt-lg-5">
    <div class="container">
        <form class="checkout-form row g-4 mt-lg-5" id="checkoutForm" action="{{route('booking.store')}}" method="post">
            @csrf
            <div class="col-lg-8 order-1 order-lg-1">
                <div class="row g-4">
                    <div class="col-12">
                        @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        <div class="accordion checkout-form-card" id="accordionExample">
                            <div class="accordion-item">
                                <h2 class="accordion-header " id="headingOne">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        @lang('app.contact-details')
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse show"
                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <x-frontend.booking.contact />
                                        <button
                                            class="btn btn-primary mt-3"
                                            type="button"
                                            data-bs-toggle="collapse"
                                            data-bs-target="#collapseTwo"
                                            aria-expanded="false"
                                            aria-controls="collapseTwo">@lang('app.traveler-details')</button>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        @lang('app.traveler-details')
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <x-frontend.booking.traveller :data="$data"/>
                                        <button
                                            class="btn btn-primary mt-3"
                                            type="button"
                                            data-bs-toggle="collapse"
                                            data-bs-target="#collapseThree"
                                            aria-expanded="false"
                                            aria-controls="collapseThree">@lang('app.payment-details')</button>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseThree" aria-expanded="false"
                                        aria-controls="collapseThree">
                                        @lang('app.payment-details')
                                    </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse"
                                    aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                    <div class="accordion-body p-4 pt-0">
                                        <x-frontend.booking.payment/>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-primary w-100 mt-3">@lang('app.book-now')</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 order-2 order-lg-2">
                <div class="booking-submission-section">
                    <div class="sidebar-widget-area">
                        <x-frontend.booking.summary :package="$package" :data="$data" />
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>
@endsection
